import numpy as np
import matplotlib.pyplot as plt

approx_degree = 6 

polyline = np.linspace(1, 129, 100)

## SBR 4dB
if 0:
	SBR4dB = np.loadtxt('./FB_SBR4dB.log', skiprows = 0, delimiter = ',', usecols = (0,1), dtype = 'float')
	N_4dB = SBR4dB[:,1]
	BER_4dB = SBR4dB[:,0]
	model1 = np.poly1d(np.polyfit(N_4dB, BER_4dB, approx_degree))
	plt.figure(1)
	plt.xlabel("N_Size")
	plt.ylabel("BER")
	plt.title("N_Size vs BER (SBR 4dB)")
	plt.grid()
	plt.scatter(N_4dB, BER_4dB, marker='o', s=5, c='r')
	plt.plot(polyline, model1(polyline), 'b--')
	plt.ylim([6.5e-4,8e-4])
	#plt.yscale('log')
	plt.savefig('./PlotMaterials/figures/NvsBER_SBR4dB.jpg')
	
## SBR 12dB
if 0:
	SBR12dB =  np.loadtxt('./FB_SBR12dB.log', skiprows = 0, delimiter = ',', usecols = (0,1), dtype = 'float')
	N_12dB = SBR12dB[:,1]
	BER_12dB = SBR12dB[:,0]
	model2 = np.poly1d(np.polyfit(N_12dB, BER_12dB, approx_degree))
	plt.figure(2)
	plt.xlabel("N_Size")
	plt.ylabel("BER")
	plt.title("N_Size vs BER (SBR 12dB)")
	plt.grid()
	plt.scatter(N_12dB, BER_12dB, marker='o', s=5, c='r')
	plt.plot(polyline, model2(polyline), 'b--')
	plt.ylim([3e-3,	6e-3])
	plt.savefig('./PlotMaterials/figures/NvsBER_SBR12dB.jpg')
	
## SBR 16dB
if 1:
	SBR16dB =  np.loadtxt('./FB_SBR16dB.log', skiprows = 0, delimiter = ',', usecols = (0,1), dtype = 'float')
	N_16dB = SBR16dB[:,1]
	BER_16dB = SBR16dB[:,0]
	model3 = np.poly1d(np.polyfit(N_16dB, BER_16dB, approx_degree))
	plt.figure(3)
	plt.xlabel("N_Size")
	plt.ylabel("BER")
	plt.title("N_Size vs BER (SBR 16dB)")
	plt.grid()
	plt.scatter(N_16dB, BER_16dB, marker='o', s=5, c='r')
	plt.plot(polyline, model3(polyline), 'b--')
	plt.ylim([1e-3,	5e-2])
	plt.savefig('./PlotMaterials/figures/NvsBER_SBR16dB.jpg')

plt.show()
